/*
    calls1.c - callbacks 010 through 019 (formerly in calls.c)

    Marc Wolfgram,  3/30/91 11:55:50
    ---------------------------------------------------------------
*/
#pragma noroot
#pragma keep "o/calls1"

#include "calls.h"

segment "F_CALLBACK";

/*
    fExtendLinkHand 010
    ---------------------------------------------------------------
        word    pCount          6
        word    index           output
        Handle  linkHand        input/output
        word    hostType        input
        Long    hostID          input
        word    resType         input
        Long    resID           input
        Word    resCheck        (ignored)
        word    resFileID       (ignored)

    Marc Wolfgram,  5/18/91  8:56:21
*/
word remExtendLinkHand(fResLinkRecPtr p)
{
word retVal, index;
resLinkRecHndl lHndl;

	(Handle) lHndl = p->linkHand;

    if (p->pCount == 6)
		retVal = setLink(lHndl, p->resType, p->resID, p->hostType, p->hostID);
    else
        retVal = invalidPcount;

	p->index = (**lHndl).count;

    return SetToolError(retVal);
}

/*
    fBuildLinkHand 011
    ---------------------------------------------------------------
        word    pCount          4 or 8
        word    index           output
        Handle  linkHand        output
        word    hostType        input
        Long    hostID          input
        word    resType         (ignored)
        Long    resID           (ignored)
        Word    resCheck        (ignored)
        word    resFileID       input

    Marc Wolfgram,  5/18/91  8:56:21
*/
word remBuildLinkHand(fResLinkRecPtr p)
{
word retVal, reqFile, i;
fLinkRec linkPB;
resLinkRecPtr lPtr;
resLinkRecHndl lHndl;
remTypeLinkPtr refP;
            

    lHndl = (resLinkRecHndl) NewHandle(4L, fMemID, 0x8018, 0L);
    if ((retVal = toolerror()) == 0) {
        HLock(lHndl);

        (**lHndl).resFileID = workList[workIndex].resFileID;
        reqFile = 0;

        switch (p->pCount) {
        case 8:
            reqFile = (**lHndl).resFileID = p->resFileID;

        case 4:
            (**lHndl).count = 0;

            refP = getTypeLinkRef(p->hostType);
            if (refP->rFlag & 0x0040) { /* we have a smart puppy */

                linkPB.resType = p->hostType;
                linkPB.resID = p->hostID;
                linkPB.resFileID = reqFile;
                linkPB.linkHand = (Handle) lHndl;

                HUnlock(lHndl);
                retVal = callREM(_GETLINK, (Pointer) &linkPB); /* install master record */
            }
            else  /* roll up your sleeves */
                retVal = addChildRef(lHndl, p->hostType, p->hostID);

            for (i = 0; i < (**lHndl).count && !retVal; i++) {
                HLock(lHndl);
                refP = getTypeLinkRef(p->hostType);
                if (refP->rFlag & 0x0040) {
					linkPB.resType = (**lHndl).ref[i].resType;
                    linkPB.resID = (**lHndl).ref[i].resID;
                    HUnlock(lHndl);
                    retVal = callREM(_GETLINK, (Pointer) &linkPB);
                    HLock(lHndl);
                }
                else
                    retVal = addChildRef(lHndl, (**lHndl).ref[i].resType, (**lHndl).ref[i].resID);
            }
            p->index = i;
            p->linkHand = (Handle) lHndl;
            break;

        default:
            retVal = invalidPcount;
        break;
        }
    }
    HUnlock(lHndl);

    return SetToolError(retVal);
}

/*
    fQueryLinkHand 012
    ---------------------------------------------------------------
        word    pCount          6, 7 or 8
        word    index           input
        Handle  linkHand        input
        word    hostType        output
        Long    hostID          output
        word    resType         output
        Long    resID           output
        Word    resCheck        output
        word    resFileID       output

    Marc Wolfgram,  5/17/91 21:05:39
*/
word remQueryLinkHand(fResLinkRecPtr p)
{
word i, retVal, index;
long hostTick, resTick;
resLinkRecHndl lHndl;

    retVal = 0;

    index = p->index - 1;
    lHndl = (resLinkRecHndl) p->linkHand;
    HLock(lHndl);

    switch (p->pCount) {
    case 8:
        p->resFileID = (**lHndl).resFileID;

    case 7:
    case 6:
        if (index < 0)
            retVal = fBadLinkIndex;

        else if (index < (**lHndl).count) {
            p->hostType = (**lHndl).ref[index].hostType;
            p->hostID = (**lHndl).ref[index].hostID;
            p->resType = (**lHndl).ref[index].resType;
            p->resID = (**lHndl).ref[index].resID;
            p->resCheck = 0;
            if (p->pCount > 6) {
                for (i = 0; i < 4; i++) {
                    if (workList[i].resFileID == p->resFileID) {
                        hostTick = getHitTick(i, p->hostType, p->hostID);
                        resTick = getHitTick(i, p->resType, p->resID);
                        p->resCheck = (resTick > hostTick);
                    }
                }
            }
        }

        else
            retVal = fLinkExhausted;
        break;

    default:
        retVal = invalidPcount;
    }
    HUnlock(lHndl);

    return SetToolError(retVal);
}

/*
    fLoadFileData 013
    ---------------------------------------------------------------
        word    pCount          min 3
        Handle  fileData        retval
        long    sfGet2ReplyRecPtr
        long    sfGet2PromptRefPtr
        long    sfGet2FileTypeRecPtr
        long    sfGet2FilterProcPtr

    Marc Wolfgram, 10/10/91 23:23:50 (Mark Collins was here for this)
*/
word remLoadFileData(fLoadFileRecPtr p)
{
word retVal;
long filterProcPtr, typeListPtr;
SFReplyRec2Ptr replyRecPtr;
ResultBuf255Ptr pathPtr;

	Word		bufSize;
	GSString255	bufString;

    retVal = 0;
    filterProcPtr = typeListPtr = 0L;

    switch (p->pCount) {
    case 5:
        filterProcPtr = p->sfGet2FilterProcPtr;

    case 4:
        typeListPtr = p->sfGet2FileTypeRecPtr;

    case 3:
        (long) p->fileData = 0L;
    	SetPort(SysWPtr);
        SFGetFile2(SFGetH[vMode], 43, 0, p->sfGet2PromptRefPtr, filterProcPtr, typeListPtr, p->sfGet2ReplyRecPtr);
        (long) replyRecPtr = p->sfGet2ReplyRecPtr;
        if (replyRecPtr->good) {
            pathPtr = (ResultBuf255Ptr) replyRecPtr->pathRef;
	        f13OpenPB.pathname = (GSString255Ptr) &pathPtr->bufString;

            OpenGS(&f13OpenPB);
            retVal = toolerror();
            if (retVal)
                break;

            p->fileData = NewHandle((long) f13OpenPB.eof, fMemID, 0x0008, 0L);
            retVal = toolerror();
            if (retVal) {
                (long) p->fileData = 0L;
                break;
            }

            f13ReadPB.pCount = 4;
            f13ReadPB.refNum = f13OpenPB.refNum;
            f13ReadPB.dataBuffer = deref(p->fileData);
            f13ReadPB.requestCount = f13OpenPB.eof;

            ReadGS(&f13ReadPB);
            retVal = toolerror();

            f13ReadPB.pCount = 1;
            CloseGS(&f13ReadPB);
            HUnlock(p->fileData);
        }
        break;

    default:
        retVal = invalidPcount;
    }

    return SetToolError(retVal);
}

/*
    fRequestEdit 014
    ---------------------------------------------------------------
        word    pCount          2 thru 4
        word    resType         input
        Long    resID           input or retVal
        Handle  resData         input (special bit 9 set)
        word    special         input (fFlag bits 8 and or 9, or 11 or 12)
        word    resFileID      (ignored)
        Pointer resName        (ignored)

    Marc Wolfgram,  4/ 7/91 13:12:29
*/
word remRequestEdit(fResDataRecPtr p)
{
word retVal;
fOpenRec    remOpenPB;

    retVal = 0;
    tempName[0] = 0x00;

    remOpenPB.resType = p->resType;
    remOpenPB.resID = p->resID;
    remOpenPB.fFlag = 0;
    remOpenPB.Data = 0L;
    remOpenPB.wColorPtr = (Pointer) WColors[workIndex + c320];

    if (p->pCount == 4) {
        if (p->special & 0x0100)        /* silent - create item & return    */
            remOpenPB.fFlag |= 0x0100;

        if (p->special & 0x0200) {      /* data provided on open            */
            remOpenPB.fFlag |= 0x2000;
            remOpenPB.Data = p->resData;
        }
        if (p->special & 0x1800) {      /* hexedit or script requested      */
            remOpenPB.fFlag |= (p->special & 0x1800);
            remOpenPB.fFlag &= 0xfeff;  /* make sure silent bit is clear    */
        }
    }

    switch (p->pCount) {
    case 3:
        remOpenPB.fFlag |= 0x0200;      /* open with provided data */
        remOpenPB.Data = p->resData;

    case 4:
    case 2:
        retVal = callREM(_OPEN, (Pointer) &remOpenPB);
        p->resID = remOpenPB.resID;

    default:
        retVal = invalidPcount;
    }

    return SetToolError(retVal);
}

/*
    fGetPrivateData 015
    ---------------------------------------------------------------
        word    pCount          2 or 4
        Pointer winPtr          input
        long    remTaskMask     output
        word    remSignature    output
        Handle  data            output
        word    groupSignature  ignored
        word    resType         ignored
        long    resID           ignored

    Marc Wolfgram,  9/16/91  0:37:16
*/
word remGetPrivateData(fPrivateDataRecPtr p)
{
word retVal;
fWindowRecHndl  refH;

    retVal = 0;
    refH = (fWindowRecHndl) GetWRefCon(p->winPtr);
    switch (p->pCount) {
    case 4:
        p->remSignature = (**refH).remSignature;
        p->Data = (**refH).resPrivate;
    case 2:
        p->remTaskMask = (**refH).remTaskMask;
        break;
    default:
        retVal = invalidPcount;
    }
    return SetToolError(retVal);
}

/*
    fSetPrivateData 016
    ---------------------------------------------------------------
        word    pCount          3
        Pointer winPtr          input
        word    remSignature    input
        Handle  data            input
        word    groupSignature  ignored
        word    resType         ignored
        long    resID           ignored

    Marc Wolfgram,  9/16/91  0:47:34
*/
word remSetPrivateData(fPrivateDataRecPtr p)
{
word retVal;
fWindowRecHndl  refH;

    retVal = 0;
    refH = (fWindowRecHndl) GetWRefCon(p->winPtr);
    switch (p->pCount) {
    case 4:
        (**refH).remSignature = p->remSignature;
        (**refH).resPrivate = p->Data;
    case 2:
        if (p->remTaskMask == 0L)
            (**refH).remTaskMask = workTaskMask = masterTaskMask;
        else if (p->remTaskMask != -1L)
            (**refH).remTaskMask = workTaskMask = p->remTaskMask;
        break;
    default:
        retVal = invalidPcount;
    }
    return SetToolError(retVal);
}

/*
    fUniqueResourceID 017
    ---------------------------------------------------------------
        word    pCount          2 or 3
        word    resType         input
        Long    resID           retVal
        word    resFileID       input

    Marc Wolfgram,  7/25/91 0:04:22
*/
word remUniqueResourceID(fResRefRecPtr p)
{
word retVal, curFile, curDepth, file;

    retVal = 0;
    file = workList[workIndex].resFileID;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);

    switch(p->pCount) {
    case 3:
        file = p->resFileID;

    case 2:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        p->resID = UniqueResourceID(-1, p->resType);
        retVal = toolerror();

        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fCountResources 018
    ---------------------------------------------------------------
        word    pCount          3 or 4
        word    resType         input
        Long    resID           ignored
        Long    result          RetVal
        word    resFileID       input

    Marc Wolfgram,  7/25/91 0:04:22
*/
word remCountResources(fResData2RecPtr p)
{
word retVal, curFile, curDepth, file;

    retVal = 0;
    file = workList[workIndex].resFileID;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);

    switch(p->pCount) {
    case 4:
        file = p->resFileID;

    case 3:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        p->result = CountResources(p->resType);
        retVal = toolerror();

        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fGetIndResource 019
    ---------------------------------------------------------------
        word    pCount          3 or 4
        word    resType         input
        Long    resID           RetVal
        Long    result          input
        word    resFileID       input

    Marc Wolfgram,  7/25/91 0:04:22
*/
word remGetIndResource(fResData2RecPtr p)
{
word retVal, curFile, curDepth, file;

    retVal = 0;
    file = workList[workIndex].resFileID;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);

    switch(p->pCount) {
    case 4:
        file = p->resFileID;

    case 3:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        p->resID = GetIndResource(p->resType, p->result);
        retVal = toolerror();

        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}
